<?php
/**
 * ServiceProvider.php 2020-3-18
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\Product\Representation\ShortDescription;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Product\Representation\ShortDescription\Listener\OnGetShortDescriptionEventListener;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Readers\Reader;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Readers\ReaderInterface;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Repository;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\RepositoryInterface;
use Gambio\Shop\SellingUnit\Presentation\Events\OnGetShortDescriptionEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\Product\Representation\ShortDescription
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var string[]
     */
    protected $provides = [
        OnGetShortDescriptionEventListener::class
    ];
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(OnGetShortDescriptionEventListener::class)->addArgument(ReadServiceInterface::class);
        $this->container->share(ReadServiceInterface::class, ReadService::class)->addArgument(RepositoryInterface::class);
        $this->container->share(RepositoryInterface::class, Repository::class)->addArgument(ReaderInterface::class);
        $this->container->share(ReaderInterface::class, Reader::class)->addArgument(Connection::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetShortDescriptionEvent::class, OnGetShortDescriptionEventListener::class);
    }
}